package w83aSindicatosEJB;

import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import javax.ejb.CreateException;
import javax.ejb.EJBException;
import javax.ejb.SessionBean;
import javax.ejb.SessionContext;

import w83a.w83aBeans.W83aCentroTrabajoCompletoBean;
import w83a.w83aBeans.W83aNuevaIncidenciasBean;
import w83a.w83aManager.W83aActa;
import w83a.w83aManager.W83aCentroTrabajo;
import w83a.w83aManager.W83aComunes;
import w83a.w83aManager.W83aDocumentacion;
import w83a.w83aManager.W83aIActa;
import w83a.w83aManager.W83aICentroTrabajo;
import w83a.w83aManager.W83aIComunes;
import w83a.w83aManager.W83aIDocumentacion;
import w83a.w83aManager.W83aIImpugnaciones;
import w83a.w83aManager.W83aIIncidencias;
import w83a.w83aManager.W83aILotesPreavisos;
import w83a.w83aManager.W83aIPreavisos;
import w83a.w83aManager.W83aIResultados;
import w83a.w83aManager.W83aImpugnaciones;
import w83a.w83aManager.W83aIncidencias;
import w83a.w83aManager.W83aLotesPreavisos;
import w83a.w83aManager.W83aPreavisos;
import w83a.w83aManager.W83aResultados;

//TODO: Auto-generated Javadoc
/**
 * The Class W83aSindicatosEJB.
 *
 * @ejb.bean name="W83aSindicatosEJB" jndi-name="w83a.W83aSindicatosEJB"
 * type="Stateless" view-type="remote" transaction-type="Container"
 * @weblogic.ejb trans-timeout-seconds="600" enable-call-by-reference="True"
 */

public class W83aSindicatosEJBBean implements SessionBean {
	
	/** The implementaciones. */
	private static Map implementaciones=new HashMap();
	
	/** The session context. */
	private SessionContext sessionContext;
	
	
	//DISPATCH IMPLEMENTACIONES
	/**
	 * Gets the comunes.
	 *
	 * @return the comunes
	 * @throws Exception the exception
	 */
	public static W83aIComunes getComunes() throws Exception{
		Object objeto = W83aSindicatosEJBBean.implementaciones.get("comunes");		
		if(objeto==null){
			objeto = W83aComunes.class.newInstance();
			W83aSindicatosEJBBean.implementaciones.put("comunes",objeto);
		}
		return (W83aIComunes)objeto;
	}
	public static W83aICentroTrabajo getCentroTrabajo() throws Exception{
		Object objeto = W83aSindicatosEJBBean.implementaciones.get("centroTrabajo");		
		if(objeto==null){
			objeto = W83aCentroTrabajo.class.newInstance();
			W83aSindicatosEJBBean.implementaciones.put("centroTrabajo",objeto);
		}
		return (W83aICentroTrabajo)objeto;
	}
	/**
	 * Gets the resultados.
	 *
	 * @return the resultados
	 * @throws Exception the exception
	 */
	public static W83aIResultados getResultados() throws Exception{
		Object objeto = W83aSindicatosEJBBean.implementaciones.get("resultados");		
		if(objeto==null){
			objeto = W83aResultados.class.newInstance();
			W83aSindicatosEJBBean.implementaciones.put("resultados",objeto);
		}
		return (W83aIResultados)objeto;
	}
	/**
	 * Gets the documentacion.
	 *
	 * @return the documentacion
	 * @throws Exception the exception
	 */
	public static W83aIDocumentacion getDocumentacion() throws Exception{
		Object objeto = W83aSindicatosEJBBean.implementaciones.get("documentacion");		
		if(objeto==null){
			objeto = W83aDocumentacion.class.newInstance();
			W83aSindicatosEJBBean.implementaciones.put("documentacion",objeto);
		}
		return (W83aIDocumentacion)objeto;
	}
	/**
	 * Gets the acta.
	 *
	 * @return the acta
	 * @throws Exception the exception
	 */
	public static W83aIActa getActa() throws Exception{
		Object objeto = W83aSindicatosEJBBean.implementaciones.get("acta");		
		if(objeto==null){
			objeto = W83aActa.class.newInstance();
			W83aSindicatosEJBBean.implementaciones.put("acta",objeto);
		}
		return (W83aIActa)objeto;
	}
	/**
	 * Gets the incidencia.
	 *
	 * @return the incidencia
	 * @throws Exception the exception
	 */
	public static W83aIIncidencias getIncidencia() throws Exception{
		Object objeto = W83aSindicatosEJBBean.implementaciones.get("incidencia");		
		if(objeto==null){
			objeto = W83aIncidencias.class.newInstance();
			W83aSindicatosEJBBean.implementaciones.put("incidencia",objeto);
		}
		return (W83aIIncidencias)objeto;
	}
	/**
	 * Gets the incidencia.
	 *
	 * @return the incidencia
	 * @throws Exception the exception
	 */
	public static W83aIImpugnaciones getImpugnacion() throws Exception{
		Object objeto = W83aSindicatosEJBBean.implementaciones.get("impugnacion");		
		if(objeto==null){
			objeto = W83aImpugnaciones.class.newInstance();
			W83aSindicatosEJBBean.implementaciones.put("impugnacion",objeto);
		}
		return (W83aIImpugnaciones)objeto;
	}
	public static W83aILotesPreavisos getLotesPreavisos() throws Exception{
		
		Object objeto = W83aSindicatosEJBBean.implementaciones.get("lotesPreavisos");
	
		if(objeto==null){
			objeto = W83aLotesPreavisos.class.newInstance();
		
			W83aSindicatosEJBBean.implementaciones.put("lotesPreavisos",objeto);
		
		}
		return (W83aILotesPreavisos)objeto;
	}
	/**
	 * Gets the preavisos.
	 *
	 * @return the preavisos
	 * @throws Exception the exception
	 */
	public static W83aIPreavisos getPreavisos() throws Exception{
		Object objeto = W83aSindicatosEJBBean.implementaciones.get("preavisos");		
		if(objeto==null){
			objeto = W83aPreavisos.class.newInstance();
			W83aSindicatosEJBBean.implementaciones.put("preavisos",objeto);
		}
		return (W83aIPreavisos)objeto;
	}
	/**
	 * Comentario para la tarea ANT de generarcion de Interfaces.
	 *
	 * @param param the param
	 * @return the java.util. map
	 * @throws Exception the exception
	 * @throws RemoteException the remote exception
	 * @ejb.interface-method view-type="remote"
	 * @ejb.transaction type="Supports"
	 * @weblogic.ejb.idempotent-methods
	 * @weblogic.ejb.transaction-isolation isolation-level="TRANSACTION_READ_COMMITTED"
	 */
	public java.util.Map buscarCabeceraCuadroResultados(w83a.w83aBeans.W83aResultadosBean param) throws  java.lang.Exception, java.rmi.RemoteException {
	
		try {
			return getResultados()
					.buscarCabeceraCuadroResultados(param);
		} catch (Exception e) {
			throw new RemoteException("", e);
		}
	}
	
	/**
	 * Comentario para la tarea ANT de generarcion de Interfaces.
	 *
	 * @param param the param
	 * @return the java.util. map
	 * @throws Exception the exception
	 * @throws RemoteException the remote exception
	 * @ejb.interface-method view-type="remote"
	 * @ejb.transaction type="Supports"
	 * @weblogic.ejb.idempotent-methods
	 * @weblogic.ejb.transaction-isolation isolation-level="TRANSACTION_READ_COMMITTED"
	 */
	public java.util.Map buscarCuadroResultados(w83a.w83aBeans.W83aResultadosBean param) throws  java.lang.Exception, java.rmi.RemoteException {

		try {
			return getResultados()
					.buscarCuadroResultados(param);
		} catch (Exception e) {
			throw new RemoteException("", e);
		}
	}
	/**
	 * Comentario para la tarea ANT de generarcion de Interfaces.
	 *
	 * @param param the param
	 * @return the java.util. map
	 * @throws Exception the exception
	 * @throws RemoteException the remote exception
	 * @ejb.interface-method view-type="remote"
	 * @ejb.transaction type="Supports"
	 * @weblogic.ejb.idempotent-methods
	 * @weblogic.ejb.transaction-isolation isolation-level="TRANSACTION_READ_COMMITTED"
	 */
	public java.util.Map buscarCabeceraCuadroResClasif(w83a.w83aBeans.W83aResultadosBean param) throws  java.lang.Exception, java.rmi.RemoteException {
	
		try {
			return getResultados()
					.buscarCabeceraCuadroResClasif(param);
		} catch (Exception e) {
			throw new RemoteException("", e);
		}
	}
	/**
	 * Comentario para la tarea ANT de generarcion de Interfaces.
	 *
	 * @param param the param
	 * @return the java.util. map
	 * @throws Exception the exception
	 * @throws RemoteException the remote exception
	 * @ejb.interface-method view-type="remote"
	 * @ejb.transaction type="Supports"
	 * @weblogic.ejb.idempotent-methods
	 * @weblogic.ejb.transaction-isolation isolation-level="TRANSACTION_READ_COMMITTED"
	 */
	public java.util.Map buscarCuadroResClasifMenorIgual49(w83a.w83aBeans.W83aResultadosBean param) throws  java.lang.Exception, java.rmi.RemoteException {
	
		try {
			return getResultados()
					.buscarCuadroResClasifMenorIgual49(param);
		} catch (Exception e) {
			throw new RemoteException("", e);
		}
	}
	/**
	 * Comentario para la tarea ANT de generarcion de Interfaces.
	 *
	 * @param param the param
	 * @return the java.util. map
	 * @throws Exception the exception
	 * @throws RemoteException the remote exception
	 * @ejb.interface-method view-type="remote"
	 * @ejb.transaction type="Supports"
	 * @weblogic.ejb.idempotent-methods
	 * @weblogic.ejb.transaction-isolation isolation-level="TRANSACTION_READ_COMMITTED"
	 */
	public java.util.Map buscarCuadroResClasifMayor49(w83a.w83aBeans.W83aResultadosBean param) throws  java.lang.Exception, java.rmi.RemoteException {
	
		try {
			return getResultados()
					.buscarCuadroResClasifMayor49(param);
		} catch (Exception e) {
			throw new RemoteException("", e);
		}
	}
	/**
	 * Ejb create.
	 *
	 * @throws CreateException Cualquier exceocion de creacion
	 * @ejb.create-method
	 */
	public void ejbCreate() throws CreateException {
	}

	/**
	 * Ejb remove.
	 *
	 * @see javax.ejb.SessionBean#ejbRemove()
	 */
	public void ejbRemove() {
	}

	/**
	 * Ejb activate.
	 *
	 * @see javax.ejb.SessionBean#ejbActivate()
	 * @author
	 */
	public void ejbActivate() {
	}

	/**
	 * Ejb passivate.
	 *
	 * @see javax.ejb.SessionBean#ejbPassivate()
	 */
	public void ejbPassivate() {
	}

	/**
	 * Sets the session context.
	 *
	 * @param sessionContext the new session context
	 * @see javax.ejb.SessionBean#setSessionContext(javax.ejb.SessionContext)
	 * @author
	 */
	public void setSessionContext(SessionContext sessionContext) {
		this.sessionContext = sessionContext;
	}

	/**
	 * Gets the session context.
	 *
	 * @return .
	 * @author
	 */
	protected SessionContext getSessionContext() {
		return this.sessionContext;
	}	
	
	//FUNCIONES EJBS

	/**
	 * Comentario para la tarea ANT de generarcion de Interfaces.
	 *
	 * @param param the param
	 * @return the w83a.w83a beans. w83a usuario xl nets bean
	 * @throws Exception the exception
	 * @throws RemoteException the remote exception
	 * @ejb.interface-method view-type="remote"
	 * @ejb.transaction type="Supports"
	 * @weblogic.ejb.idempotent-methods
	 * @weblogic.ejb.transaction-isolation isolation-level="TRANSACTION_READ_COMMITTED"
	 */
		public w83a.w83aBeans.W83aUsuarioXLNetsBean buscarDatosUsuario(w83a.w83aBeans.W83aUsuarioXLNetsBean param) throws  java.lang.Exception, java.rmi.RemoteException {
			
			try {
				return getComunes()
				.buscarDatosUsuario(param);
			} catch (Exception e) {
				throw new RemoteException("", e);
			}
		}
		/**
		 * Comentario para la tarea ANT de generarcion de Interfaces.
		 *
		 * @param param the param
		 * @return the w83a.w83a beans. w83a usuario xl nets bean
		 * @throws Exception the exception
		 * @throws RemoteException the remote exception
		 * @ejb.interface-method view-type="remote"
		 * @ejb.transaction type="Supports"
		 * @weblogic.ejb.idempotent-methods
		 * @weblogic.ejb.transaction-isolation isolation-level="TRANSACTION_READ_COMMITTED"
		 */
		public java.util.List buscarCentroTrabajo(w83a.w83aBeans.W83aCentroTrabajoBean param) throws  java.lang.Exception, java.rmi.RemoteException {

			try {
				return getCentroTrabajo()
						.buscarCentroTrabajo(param);
			} catch (Exception e) {
				throw new RemoteException("", e);
			}
		}
		/**
		 * Comentario para la tarea ANT de generarcion de Interfaces.
		 *
		 * @param param the param
		 * @return the w83a.w83a beans. w83a usuario xl nets bean
		 * @throws Exception the exception
		 * @throws RemoteException the remote exception
		 * @ejb.interface-method view-type="remote"
		 * @ejb.transaction type="Supports"
		 * @weblogic.ejb.idempotent-methods
		 * @weblogic.ejb.transaction-isolation isolation-level="TRANSACTION_READ_COMMITTED"
		 */
		public java.util.List buscarCentroTrabajoDocumentacion(w83a.w83aBeans.W83aCentroTrabajoBean param) throws  java.lang.Exception, java.rmi.RemoteException {

			try {
				return getCentroTrabajo()
						.buscarCentroTrabajoDocumentacion(param);
			} catch (Exception e) {
				throw new RemoteException("", e);
			}
		}
		/**
		 * Comentario para la tarea ANT de generarcion de Interfaces.
		 *
		 * @param param the param
		 * @return the java.util. list
		 * @throws Exception the exception
		 * @throws RemoteException the remote exception
		 * @ejb.interface-method view-type="remote"
		 * @ejb.transaction type="Supports"
		 * @weblogic.ejb.idempotent-methods
		 * @weblogic.ejb.transaction-isolation isolation-level="TRANSACTION_READ_COMMITTED"
		 */
		public java.util.List buscarLotesPreavisos(w83a.w83aBeans.W83aLotesPreavisosBean param) throws  java.lang.Exception, java.rmi.RemoteException {

			try {
				return getLotesPreavisos()
						.buscarLotesPreavisos(param);
			} catch (Exception e) {
				throw new RemoteException("", e);
			}
		}
			
		
		/**
		 * Comentario para la tarea ANT de generarcion de Interfaces.
		 *
		 * @param param the param
		 * @return the w83a.w83a beans. w83a lotesPreavisos bean
		 * @throws Exception the exception
		 * @throws RemoteException the remote exception
		 * @ejb.interface-method view-type="remote"
		 * @ejb.transaction type="Supports"
		 * @weblogic.ejb.idempotent-methods
		 * @weblogic.ejb.transaction-isolation isolation-level="TRANSACTION_READ_COMMITTED"
		 */
	public w83a.w83aBeans.W83aLotesPreavisosBean detalleLotesPreavisos(w83a.w83aBeans.W83aLotesPreavisosBean param) throws  java.lang.Exception, java.rmi.RemoteException {
		
		try {
			return getLotesPreavisos()
			.detalleLotesPreavisos(param);
		} catch (Exception e) {
			throw new RemoteException("", e);
		}
	}
	
	/**
	 * Comentario para la tarea ANT de generarcion de Interfaces.
	 *
	 * @param param the param
	 * @return the w83a.w83a beans. w83a lotesPreavisos bean
	 * @throws Exception the exception
	 * @throws RemoteException the remote exception
	 * @ejb.interface-method view-type="remote"
	 * @ejb.transaction type="Supports"
	 * @weblogic.ejb.idempotent-methods
	 * @weblogic.ejb.transaction-isolation isolation-level="TRANSACTION_READ_COMMITTED"
	 */
	public java.util.List detallePreavisos(w83a.w83aBeans.W83aLotesPreavisosBean param) throws  java.lang.Exception, java.rmi.RemoteException {
		
		try {
			return getLotesPreavisos()
			.detallePreavisos(param);
		} catch (Exception e) {
			throw new RemoteException("", e);
		}
	}

	/**
	 * Comentario para la tarea ANT de generarcion de Interfaces.
	 *
	 * @param param the param
	 * @return the w83a.w83a beans. w83a lotesPreavisos bean
	 * @throws Exception the exception
	 * @throws RemoteException the remote exception
	 * @ejb.interface-method view-type="remote"
	 * @ejb.transaction type="Supports"
	 * @weblogic.ejb.idempotent-methods
	 * @weblogic.ejb.transaction-isolation isolation-level="TRANSACTION_READ_COMMITTED"
	 */
	public w83a.w83aBeans.W83aLotesPreavisosBean obtenerDetallePreaviso(w83a.w83aBeans.W83aLotesPreavisosBean param) throws  java.lang.Exception, java.rmi.RemoteException {
		
		try {
			return getLotesPreavisos()
			.obtenerDetallePreaviso(param);
		} catch (Exception e) {
			throw new RemoteException("", e);
		}
	}
		/**
		 * Comentario para la tarea ANT de generarcion de Interfaces.
		 *
		 * @param param the param
		 * @return the java.lang. integer
		 * @throws Exception the exception
		 * @ejb.interface-method view-type="remote"
		 * @ejb.transaction type="Supports"
		 * @weblogic.ejb.idempotent-methods
		 * @weblogic.ejb.transaction-isolation isolation-level="TRANSACTION_READ_COMMITTED"
		 */
		public java.lang.Integer contarCentroTrabajo(w83a.w83aBeans.W83aCentroTrabajoBean param) throws Exception{
			
			try {
				return getCentroTrabajo()
				.contarCentroTrabajo(param);
			} catch (Exception e) {
				throw new RemoteException("", e);
			}
		}
		/**
		 * Comentario para la tarea ANT de generarcion de Interfaces.
		 *
		 * @param param the param
		 * @return the java.lang. integer
		 * @throws Exception the exception
		 * @ejb.interface-method view-type="remote"
		 * @ejb.transaction type="Supports"
		 * @weblogic.ejb.idempotent-methods
		 * @weblogic.ejb.transaction-isolation isolation-level="TRANSACTION_READ_COMMITTED"
		 */
		public java.lang.Integer contarCentroTrabajoDocumentacion(w83a.w83aBeans.W83aCentroTrabajoBean param) throws Exception{
			
			try {
				return getCentroTrabajo()
				.contarCentroTrabajoDocumentacion(param);
			} catch (Exception e) {
				throw new RemoteException("", e);
			}
		}
		/**
		 * Comentario para la tarea ANT de generarcion de Interfaces.
		 *
		 * @param param the param
		 * @return the w83a.w83a beans. w83a usuario xl nets bean
		 * @throws Exception the exception
		 * @throws RemoteException the remote exception
		 * @ejb.interface-method view-type="remote"
		 * @ejb.transaction type="Supports"
		 * @weblogic.ejb.idempotent-methods
		 * @weblogic.ejb.transaction-isolation isolation-level="TRANSACTION_READ_COMMITTED"
		 */
		public java.util.HashMap buscarDocumentacion(w83a.w83aBeans.W83aDocumentacionBean param) throws  java.lang.Exception, java.rmi.RemoteException {

			try {
				
				return getDocumentacion().buscarDocumentacion(param);
			} catch (Exception e) {
				throw new RemoteException("", e);
			}
		}
		/**
		 * Comentario para la tarea ANT de generarcion de Interfaces.
		 *
		 * @param param the param
		 * @return the w83a.w83a beans. w83a actas bean
		 * @throws Exception the exception
		 * @throws RemoteException the remote exception
		 * @ejb.interface-method view-type="remote"
		 * @ejb.transaction type="Supports"
		 * @weblogic.ejb.idempotent-methods
		 * @weblogic.ejb.transaction-isolation isolation-level="TRANSACTION_READ_COMMITTED"
		 */
		public w83a.w83aBeans.W83aActasBean detalleActas(w83a.w83aBeans.W83aActasBean param) throws  java.lang.Exception, java.rmi.RemoteException {
			
			try {
				return getActa().detalleActas(param);
			} catch (Exception e) {
				throw new RemoteException("", e);
			}
		}
		/**
		 * Comentario para la tarea ANT de generarcion de Interfaces.
		 *
		 * @param param the param
		 * @return the w83a.w83a beans. w83a actas bean
		 * @throws Exception the exception
		 * @throws RemoteException the remote exception
		 * @ejb.interface-method view-type="remote"
		 * @ejb.transaction type="Supports"
		 * @weblogic.ejb.idempotent-methods
		 * @weblogic.ejb.transaction-isolation isolation-level="TRANSACTION_READ_COMMITTED"
		 */
		public w83a.w83aBeans.W83aActasBean cargarListasActas(w83a.w83aBeans.W83aActasBean param) throws  java.lang.Exception, java.rmi.RemoteException {
			
			try {
				return getActa().cargarListasActas(param);
			} catch (Exception e) {
				throw new RemoteException("", e);
			}
		}
		/**
		 * Comentario para la tarea ANT de generarcion de Interfaces.
		 *
		 * @param idDocumento the id documento
		 * @return the w83a.w83a beans. w83a doc bean
		 * @throws Exception the exception
		 * @throws RemoteException the remote exception
		 * @ejb.interface-method view-type="remote"
		 * @ejb.transaction type="Supports"
		 * @weblogic.ejb.idempotent-methods
		 * @weblogic.ejb.transaction-isolation isolation-level="TRANSACTION_READ_COMMITTED"
		 */
		public w83a.w83aBeans.W83aDocBean descargarDocumento(String idDocumento) throws  java.lang.Exception, java.rmi.RemoteException {

			try {
					return getDocumentacion().descargarDocumento(idDocumento);
			} catch (Exception e) {
				throw new RemoteException("", e);
			}
		}
		/**
		 * Comentario para la tarea ANT de generarcion de Interfaces.
		 *
		 * @param idDocumento the id documento
		 * @return the w83a.w83a beans. w83a doc bean
		 * @throws Exception the exception
		 * @throws RemoteException the remote exception
		 * @ejb.interface-method view-type="remote"
		 * @ejb.transaction type="Supports"
		 * @weblogic.ejb.idempotent-methods
		 * @weblogic.ejb.transaction-isolation isolation-level="TRANSACTION_READ_COMMITTED"
		 */
		public w83a.w83aBeans.W83aDocBean descargarDocumentoActa(String idDocumento) throws  java.lang.Exception, java.rmi.RemoteException {

			try {
					return getActa().descargarDocumento(idDocumento);
			} catch (Exception e) {
				throw new RemoteException("", e);
			}
		}
		
		
		/**
		 * Comentario para la tarea ANT de generarcion de Interfaces.
		 *
		 * @param param the param
		 * @return the java.lang. string
		 * @throws EJBException the eJB exception
		 * @ejb.interface-method view-type="remote"
		 * @ejb.transaction type="Required"
		 * @weblogic.ejb.idempotent-methods
		 * @weblogic.ejb.transaction-isolation isolation-level="TRANSACTION_READ_COMMITTED"
		 */
		public HashMap guardarLotePreavisos(w83a.w83aBeans.W83aLotesPreavisosBean param) throws  javax.ejb.EJBException {
			
				try{
					HashMap resultado=getLotesPreavisos().anyadirLotePreavisos(param);
					
					//getLotesPreavisos().insertarDocsLotePreavisos(param);
					
//					
//					String fechaRegistro = (String)resultado.get("fechaRegistro");
//					
//					if ("1".equals(param.getUsuarioBean().getRegManual())){
//						fechaRegistro = "1";
//					}

					return resultado;//+"___"+fechaRegistro;
				}
				catch (Exception e)
				{
					this.sessionContext.setRollbackOnly();
					throw new EJBException(e);
				}
				
		}
		/**
		 * Comentario para la tarea ANT de generarcion de Interfaces.
		 *
		 * @param param the param
		 * @return the java.util. hash map
		 * @throws Exception the exception
		 * @throws RemoteException the remote exception
		 * @ejb.interface-method view-type="remote"
		 * @ejb.transaction type="Supports"
		 * @weblogic.ejb.idempotent-methods
		 * @weblogic.ejb.transaction-isolation isolation-level="TRANSACTION_READ_COMMITTED"
		 */
		public java.util.HashMap buscarEscrutinio(w83a.w83aBeans.W83aActasBean param) throws  java.lang.Exception, java.rmi.RemoteException {
			try {
				return getActa()
						.buscarEscrutinio(param);
			} catch (Exception e) {
				throw new RemoteException("", e);
			}
		}
		
		
		
		/**
		 * Comentario para la tarea ANT de generarcion de Interfaces.
		 *
		 * @param param the param
		 * @return the java.util. hash map
		 * @throws Exception the exception
		 * @throws RemoteException the remote exception
		 * @ejb.interface-method view-type="remote"
		 * @ejb.transaction type="Supports"
		 * @weblogic.ejb.idempotent-methods
		 * @weblogic.ejb.transaction-isolation isolation-level="TRANSACTION_READ_COMMITTED"
		 */
		public java.util.HashMap buscarDiferencia(w83a.w83aBeans.W83aActasBean param) throws  java.lang.Exception, java.rmi.RemoteException {
			try {
				return getActa()
						.buscarDiferencia(param);
			} catch (Exception e) {
				throw new RemoteException("", e);
			}
		}
		
		/**
		 * Comentario para la tarea ANT de generarcion de Interfaces.
		 *
		 * @param param the param
		 * @return the java.util. hash map
		 * @throws Exception the exception
		 * @throws RemoteException the remote exception
		 * @ejb.interface-method view-type="remote"
		 * @ejb.transaction type="Supports"
		 * @weblogic.ejb.idempotent-methods
		 * @weblogic.ejb.transaction-isolation isolation-level="TRANSACTION_READ_COMMITTED"
		 */
		public java.util.HashMap buscarDelegado(w83a.w83aBeans.W83aActasBean param) throws  java.lang.Exception, java.rmi.RemoteException {
			try {
				return getActa()
						.buscarListaDelegados(param);
			} catch (Exception e) {
				throw new RemoteException("", e);
			}
		}
		/**
		 * Comentario para la tarea ANT de generarcion de Interfaces.
		 *
		 * @param param the param
		 * @return the java.util. map
		 * @throws Exception the exception
		 * @ejb.interface-method view-type="remote"
		 * @ejb.transaction type="Supports"
		 * @weblogic.ejb.idempotent-methods
		 * @weblogic.ejb.transaction-isolation isolation-level="TRANSACTION_READ_COMMITTED"
		 */
		public W83aNuevaIncidenciasBean detalleIncidencia(w83a.w83aBeans.W83aNuevaIncidenciasBean param) throws Exception{
			
			try {
				return getIncidencia()
				.detalleIncidencia(param);
			} catch (Exception e) {
				throw new RemoteException("", e);
			}
		}
		/**
		 * Comentario para la tarea ANT de generarcion de Interfaces.
		 *
		 * @param param the param
		 * @return the w83a.w83a beans. w83a usuario xl nets bean
		 * @throws Exception the exception
		 * @throws RemoteException the remote exception
		 * @ejb.interface-method view-type="remote"
		 * @ejb.transaction type="Supports"
		 * @weblogic.ejb.idempotent-methods
		 * @weblogic.ejb.transaction-isolation isolation-level="TRANSACTION_READ_COMMITTED"
		 */
		public w83a.w83aBeans.W83aUsuarioXLNetsBean darAltaRegistroNuevoNumeroEntradaDelegacion(w83a.w83aBeans.W83aUsuarioXLNetsBean param) throws  java.lang.Exception, java.rmi.RemoteException {

			try {
				return getComunes()
						.darAltaRegistroNuevoNumeroEntradaDelegacion(param);
			} catch (Exception e) {
				throw new RemoteException("", e);
			}
		}
		
		/**
		 * Comentario para la tarea ANT de generarcion de Interfaces.
		 *
		 * @param param the param
		 * @return the w83a.w83a beans. w83a usuario xl nets bean
		 * @throws Exception the exception
		 * @throws RemoteException the remote exception
		 * @ejb.interface-method view-type="remote"
		 * @ejb.transaction type="Supports"
		 * @weblogic.ejb.idempotent-methods
		 * @weblogic.ejb.transaction-isolation isolation-level="TRANSACTION_READ_COMMITTED"
		 */
		public w83a.w83aBeans.W83aUsuarioXLNetsBean refrescarUsuarioDelegacion(w83a.w83aBeans.W83aUsuarioXLNetsBean param) throws  java.lang.Exception, java.rmi.RemoteException {
			
			try {
				return getComunes()
				.refrescarUsuarioDelegacion(param);
			} catch (Exception e) {
				throw new RemoteException("", e);
			}
		}
		
		/**
		 * Comentario para la tarea ANT de generarcion de Interfaces.
		 *
		 * @param param the param
		 * @return the w83a.w83a beans. w83a usuario xl nets bean
		 * @throws Exception the exception
		 * @throws RemoteException the remote exception
		 * @ejb.interface-method view-type="remote"
		 * @ejb.transaction type="Supports"
		 * @weblogic.ejb.idempotent-methods
		 * @weblogic.ejb.transaction-isolation isolation-level="TRANSACTION_READ_COMMITTED"
		 */
		public w83a.w83aBeans.W83aUsuarioXLNetsBean refrescarRegistroAutomaticoUsuarioDelegacion(w83a.w83aBeans.W83aUsuarioXLNetsBean param) throws  java.lang.Exception, java.rmi.RemoteException {
			
			try {
				return getComunes()
				.refrescarRegistroAutomaticoUsuarioDelegacion(param);
			} catch (Exception e) {
				throw new RemoteException("", e);
			}
		}
		
		/**
		 * Comentario para la tarea ANT de generarcion de Interfaces.
		 *
		 * @param param the param
		 * @return the java.util. list
		 * @throws Exception the exception
		 * @throws RemoteException the remote exception
		 * @ejb.interface-method view-type="remote"
		 * @ejb.transaction type="Supports"
		 * @weblogic.ejb.idempotent-methods
		 * @weblogic.ejb.transaction-isolation isolation-level="TRANSACTION_READ_COMMITTED"
		 */
		public java.lang.String contarBuscarDelegadosConvenio(w83a.w83aBeans.W83aResultadosBean param) throws  java.lang.Exception, java.rmi.RemoteException {
			
			try {
//				long tiempo = System.currentTimeMillis();
				HashMap listaResultados = ((HashMap)getResultados()
				.buscarDelegadosConvenio(param,true));
				//System.out.println("TIEMPO =>"+(System.currentTimeMillis()-tiempo));
				return ((ArrayList)listaResultados.get("lista")).get(0).toString();
			} catch (Exception e) {
				throw new RemoteException("", e);
			}
		}
		
		/**
		 * Comentario para la tarea ANT de generarcion de Interfaces.
		 *
		 * @param param the param
		 * @return the java.util. map
		 * @throws Exception the exception
		 * @throws RemoteException the remote exception
		 * @ejb.interface-method view-type="remote"
		 * @ejb.transaction type="Required"
		 * @weblogic.ejb.idempotent-methods
		 * @weblogic.ejb.transaction-isolation isolation-level="TRANSACTION_READ_COMMITTED"
		 */
		public java.util.Map buscarDelegadosConvenio(w83a.w83aBeans.W83aResultadosBean param) throws  java.lang.Exception, java.rmi.RemoteException {

			try {
				return getResultados()
						.buscarDelegadosConvenio(param,false);
			} catch (Exception e) {
				throw new RemoteException("", e);
			}
		}
		
		/**
		 * Comentario para la tarea ANT de generarcion de Interfaces.
		 *
		 * @param param the param
		 * @return the w83b.w83b beans. w83b preavisos bean
		 * @throws Exception the exception
		 * @throws RemoteException the remote exception
		 * @ejb.interface-method view-type="remote"
		 * @ejb.transaction type="Supports"
		 * @weblogic.ejb.idempotent-methods
		 * @weblogic.ejb.transaction-isolation isolation-level="TRANSACTION_READ_COMMITTED"
		 */
		public w83a.w83aBeans.W83aPreavisosBean obtenerDetallesPreaviso (java.util.HashMap param) throws  java.lang.Exception, java.rmi.RemoteException {

			try {
				return getPreavisos().obtenerDetallesPreaviso(param);
			} catch (Exception e) {
				throw new RemoteException("", e);
			}
		}
		
		/**
		 * Comentario para la tarea ANT de generarcion de Interfaces.
		 *
		 * @param idDocumento the id documento
		 * @return the w83a.w83a beans. w83a doc bean
		 * @throws Exception the exception
		 * @throws RemoteException the remote exception
		 * @ejb.interface-method view-type="remote"
		 * @ejb.transaction type="Supports"
		 * @weblogic.ejb.idempotent-methods
		 * @weblogic.ejb.transaction-isolation isolation-level="TRANSACTION_READ_COMMITTED"
		 */
		public w83a.w83aBeans.W83aDocBean descargarDocumentoIncidencias (String idDocumento) throws  java.lang.Exception, java.rmi.RemoteException {
			
			try {
				return getIncidencia().descargarDocumentoIncidencias(idDocumento);
			} catch (Exception e) {
				throw new RemoteException("", e);
			}
		}
		/**
		 * Comentario para la tarea ANT de generarcion de Interfaces.
		 *
		 * @param idDocumento the id documento
		 * @return the w83a.w83a beans. w83a doc bean
		 * @throws Exception the exception
		 * @throws RemoteException the remote exception
		 * @ejb.interface-method view-type="remote"
		 * @ejb.transaction type="Supports"
		 * @weblogic.ejb.idempotent-methods
		 * @weblogic.ejb.transaction-isolation isolation-level="TRANSACTION_READ_COMMITTED"
		 */
		public w83a.w83aBeans.W83aDocBean descargarDocumentoImpugnaciones (String idDocumento) throws  java.lang.Exception, java.rmi.RemoteException {
			
			try {
				return getImpugnacion().descargarDocumento(idDocumento);
			} catch (Exception e) {
				throw new RemoteException("", e);
			}
		}
		/**
		 * Comentario para la tarea ANT de generarcion de Interfaces.
		 *
		 * @param param the param
		 * @return the java.util. list
		 * @throws Exception the exception
		 * @throws RemoteException the remote exception
		 * @ejb.interface-method view-type="remote"
		 * @ejb.transaction type="Supports"
		 * @weblogic.ejb.idempotent-methods
		 * @weblogic.ejb.transaction-isolation isolation-level="TRANSACTION_READ_COMMITTED"
		 */
		public java.util.List buscarCentroTrabajoActa(w83a.w83aBeans.W83aCentroTrabajoBean param) throws  java.lang.Exception, java.rmi.RemoteException {

			try {
				return getActa()
						.buscarCentroTrabajo(param);
			} catch (Exception e) {
				throw new RemoteException("", e);
			}
		}
		/**
		 * Comentario para la tarea ANT de generarcion de Interfaces.
		 *
		 * @param idDocumento the id documento
		 * @return the w83a.w83a beans. w83a doc bean
		 * @throws Exception the exception
		 * @throws RemoteException the remote exception
		 * @ejb.interface-method view-type="remote"
		 * @ejb.transaction type="Supports"
		 * @weblogic.ejb.idempotent-methods
		 * @weblogic.ejb.transaction-isolation isolation-level="TRANSACTION_READ_COMMITTED"
		 */
		public w83a.w83aBeans.W83aDocBean descargarDocumentoPreaviso (String idDocumento) throws  java.lang.Exception, java.rmi.RemoteException {

			try {
					return getPreavisos().descargarDocumento(idDocumento);
			} catch (Exception e) {
				throw new RemoteException("", e);
			}
		}
		/**
		 * Comentario para la tarea ANT de generarcion de Interfaces.
		 *
		 * @param hasCnae the has cnae
		 * @return the w83a centro trabajo completo bean
		 * @throws Exception the exception
		 * @ejb.interface-method view-type="remote"
		 * @ejb.transaction type="Supports"
		 * @weblogic.ejb.idempotent-methods
		 * @weblogic.ejb.transaction-isolation isolation-level="TRANSACTION_READ_COMMITTED"
		 */
		public W83aCentroTrabajoCompletoBean detalleCentroTrabajo(HashMap hasCnae) throws Exception{
			
			try {
				return getCentroTrabajo()
				.detalleCentroTrabajo(hasCnae);
			} catch (Exception e) {
				throw new RemoteException("", e);
			}
		}
		/**
		 * Comentario para la tarea ANT de generarcion de Interfaces.
		 *
		 * @param param the param
		 * @return the w83a.w83a beans. w83a lotesPreavisos bean
		 * @throws Exception the exception
		 * @throws RemoteException the remote exception
		 * @ejb.interface-method view-type="remote"
		 * @ejb.transaction type="Supports"
		 * @weblogic.ejb.idempotent-methods
		 * @weblogic.ejb.transaction-isolation isolation-level="TRANSACTION_READ_COMMITTED"
		 */
		public w83a.w83aBeans.W83aLotesPreavisosBean firmarDocumento(w83a.w83aBeans.W83aLotesPreavisosBean param) throws  java.lang.Exception, java.rmi.RemoteException {
			
			try {
				return getLotesPreavisos()
				.firmarDocumento(param);
			} catch (Exception e) {
				throw new RemoteException("", e);
			}
		}
		/**
		 * Comentario para la tarea ANT de generarcion de Interfaces.
		 *
		 * @param param the param
		 * @return the w83a.w83a beans. w83a lotesPreavisos bean
		 * @throws Exception the exception
		 * @throws RemoteException the remote exception
		 * @ejb.interface-method view-type="remote"
		 * @ejb.transaction type="Supports"
		 * @weblogic.ejb.idempotent-methods
		 * @weblogic.ejb.transaction-isolation isolation-level="TRANSACTION_READ_COMMITTED"
		 */
		public w83a.w83aBeans.W83aLotesPreavisosBean generarNotificaciones(w83a.w83aBeans.W83aLotesPreavisosBean param) throws  java.lang.Exception, java.rmi.RemoteException {
			
			try {
				return getLotesPreavisos()
				.generarNotificaciones(param);
			} catch (Exception e) {
				throw new RemoteException("", e);
			}
		}
		/**
		 * Comentario para la tarea ANT de generarcion de Interfaces.
		 *
		 * @param param the param
		 * @return the w83a.w83a beans. w83a lotesPreavisos bean
		 * @throws Exception the exception
		 * @throws RemoteException the remote exception
		 * @ejb.interface-method view-type="remote"
		 * @ejb.transaction type="Supports"
		 * @weblogic.ejb.idempotent-methods
		 * @weblogic.ejb.transaction-isolation isolation-level="TRANSACTION_READ_COMMITTED"
		 */
		public w83a.w83aBeans.W83aLotesPreavisosBean deshacerAltaLote(w83a.w83aBeans.W83aLotesPreavisosBean param) throws  java.lang.Exception, java.rmi.RemoteException {
			
			try {
				return getLotesPreavisos()
				.deshacerAltaLote(param);
			} catch (Exception e) {
				throw new RemoteException("", e);
			}
		}
		/**
		 * Comentario para la tarea ANT de generarcion de Interfaces.
		 *
		 * @param param the param
		 * @return the w83b.w83b beans. w83b impugnacion bean
		 * @throws Exception the exception
		 * @throws RemoteException the remote exception
		 * @ejb.interface-method view-type="remote"
		 * @ejb.transaction type="Supports"
		 * @weblogic.ejb.idempotent-methods
		 * @weblogic.ejb.transaction-isolation isolation-level="TRANSACTION_READ_COMMITTED"
		 */
		public w83a.w83aBeans.W83aImpugnacionBean obtenerDetallesImpugnacion (java.util.HashMap param) throws  java.lang.Exception, java.rmi.RemoteException {

			try {
				return getImpugnacion().obtenerDetallesImpugnacion(param);
			} catch (Exception e) {
				throw new RemoteException("", e);
			}
		}
		/**
		 * Comentario para la tarea ANT de generarcion de Interfaces.
		 *
		 * @param param the param
		 * @return the java.util. list
		 * @throws Exception the exception
		 * @throws RemoteException the remote exception
		 * @ejb.interface-method view-type="remote"
		 * @ejb.transaction type="Supports"
		 * @weblogic.ejb.idempotent-methods
		 * @weblogic.ejb.transaction-isolation isolation-level="TRANSACTION_READ_COMMITTED"
		 */
		public java.lang.String contarBuscarResCentroSindicato(w83a.w83aBeans.W83aResultadosBean param) throws  java.lang.Exception, java.rmi.RemoteException {
			
			try {
//				long tiempo = System.currentTimeMillis();
				List listaResultados = getResultados()
				.buscarResCentroSindicato(param,true);
				//System.out.println("TIEMPO =>"+(System.currentTimeMillis()-tiempo));
				return listaResultados.get(0).toString();
			} catch (Exception e) {
				throw new RemoteException("", e);
			}
		}
		/**
		 * Comentario para la tarea ANT de generarcion de Interfaces.
		 *
		 * @param param the param
		 * @return the java.util. list
		 * @throws Exception the exception
		 * @throws RemoteException the remote exception
		 * @ejb.interface-method view-type="remote"
		 * @ejb.transaction type="Supports"
		 * @weblogic.ejb.idempotent-methods
		 * @weblogic.ejb.transaction-isolation isolation-level="TRANSACTION_READ_COMMITTED"
		 */
		public java.util.List buscarResCentroSindicato(w83a.w83aBeans.W83aResultadosBean param) throws  java.lang.Exception, java.rmi.RemoteException {

			try {
				//long tiempo = System.currentTimeMillis();
				List listaResultados = getResultados()
				.buscarResCentroSindicato(param,false);
				//System.out.println("TIEMPO =>"+(System.currentTimeMillis()-tiempo));
				return listaResultados;
			} catch (Exception e) {
				throw new RemoteException("", e);
			}
		}
	}
	

	

